﻿from tkinter import *
from tkinter import ttk
from random import randrange
import os.path

tempo=400   # pour eviter les rebonds de souris
ok_clic=1
def tmp_clic():
    global ok_clic
    ok_clic=1
def temporisation_clic():
    global ok_clic
    ok_clic=0
    fen1.after(tempo,tmp_clic)





class Point(object):
    "Point geométrique"
    delta_x=5   # rayon du cercle pour le point
    def __init__(self,pointx,pointy,coul='black',epaiss=5):
        "création d'un point"
        self.x=pointx
        self.y=pointy
        self.coul=coul
        self.ep=epaiss
        self.cercle=None


    def trace(self):
        "tracé d'un point"
        self.cercle=can1.create_oval(paspixel*self.x-self.ep,paspixel*self.y-self.ep,paspixel*self.x+self.ep,paspixel*self.y+self.ep, width=1, fill=self.coul)


    def suppr(self):
        #print("destruction d'un point")
        self.coul=None
        can1.delete(self.cercle)

    def efface(self):
        can1.delete(self.cercle)

    def change_coul(self,couleur):
        can1.itemconfigure(self.cercle, fill=couleur)




class Fil(object):
    "Fil"
    def __init__(self,p1,epais=2,coul="black"):
        self.liste=[]
        self.liste.append(p1)
        self.liste_lignes=[]
        self.coul=coul
        self.epais=epais

    def ajoute(self,p):
        self.liste.append(p)

    def trace(self):
        self.liste[0].trace()
        for i in range (1,len(self.liste)):

            ligne=can1.create_line(paspixel*self.liste[i-1].x,paspixel*self.liste[i-1].y,\
            paspixel*self.liste[i].x,paspixel*self.liste[i].y,fill=self.coul,width=self.epais)
            self.liste_lignes.append(ligne)
        self.liste[-1].trace()

    def suppr(self):
        for i in range (len(self.liste_lignes)):
            can1.delete(self.liste_lignes[i])
        if len(self.liste)==1:
            #print("detruire 1 seul point")
            self.liste[0].suppr()
            self.liste=None

        else:
            self.liste[0].suppr()
            self.liste[-1].suppr()
            self.liste=None
            self.liste_lignes=None

    def efface(self):
        for i in range (len(self.liste_lignes)):
            can1.delete(self.liste_lignes[i])
        if len(self.liste)==1:
            #print("un seul point")
            self.liste[0].efface()
        else:
            self.liste[0].efface()
            self.liste[-1].efface()

    def change_coul(self,couleur):
        for i in range (len(self.liste_lignes)):
            can1.itemconfigure(self.liste_lignes[i], fill=couleur)



def choix_action():
    "Action des boutons radio pour la sélection d'une action"
    global l_coul, drapeau_man, numero_action
    numero_action=type_action.get()
    if numero_action==0:
        drapeau_man=0
    elif numero_action==1:
        l_coul=['magenta']
        drapeau_man=1
    elif numero_action==2:
        #l_coul=[vit_coul]
        drapeau_man=2
        clean()                   # appel de la fonction qui élimine les points isolés
    elif numero_action==3:
        l_coul=[accel_coul]
        drapeau_man=3
    elif numero_action==5:
        l_coul=[forceacc_coul]
        drapeau_man=5
    else:
        l_coul=[force_coul]
        drapeau_man=4

class Voltmetre(object):
    #delta_x=9   # rayon du cercle pour le voltmetre
    def __init__(self,pointx,pointy,fil,coul='aqua',epaiss=9):
        "création d'un point"
        self.x=pointx
        self.y=pointy
        self.coul=coul
        self.ep=epaiss
        self.cercle=None
        self.fil=fil          # numero du fil


    def trace(self):
        "tracé d'un point"
        self.cercle=can1.create_oval(paspixel*self.x-self.ep,paspixel*self.y-self.ep,paspixel*self.x+self.ep,paspixel*self.y+self.ep, width=1, fill=self.coul)

    def suppr(self):
        #print("destruction d'un point")
        self.coul=None
        can1.delete(self.cercle)

    def efface(self):
        can1.delete(self.cercle)

    def change_coul(self):
        can1.itemconfigure(self.cercle, fill=self.coul)





class Composant(object):
    global imga,imgb
    def __init__(self,icompolu,x,y):
        global  charge_0
        self.type=icompolu
        self.x=x
        self.y=y
        self.img=imga[icompolu]
        self.cmp_des=can1.create_image(self.x*paspixel,self.y*paspixel,image=self.img)
        self.cx=[]   # corrdonnées des bornes du composant
        self.cy=[]
        self.borne=[]
        self.etat=[]
        self.dx=0
        self.dy=0   # dimension de la photo du composant à cliquer

        if self.type==0:
            # creation d'un transistor
            self.cx.append(self.x-2)
            self.cy.append(self.y-2)  # base jaune (100kohms)
            self.cx.append(self.x-2)
            self.cy.append(self.y+2)  # base bleue
            self.cx.append(self.x+2)
            self.cy.append(self.y-2)  # plus rouge
            self.cx.append(self.x+2)
            self.cy.append(self.y)    # collecteur vert
            self.cx.append(self.x+2)
            self.cy.append(self.y+2)  # emetteur noir
            self.borne.append(0)
            self.borne.append(1)
            self.borne.append(2)
            self.borne.append(3)
            self.borne.append(4)
            self.etat.append(0) # base à 0 ou non connectée par 100 K (jaune)
            self.etat.append(2) # base bleue non connectée à un condensateur 1 cond chargé 0 cond en charge
            self.etat.append(0) # rouge pas relié au plus
            self.etat.append(1) # collecteur non passant
            self.etat.append(0) # emetteur pas relié au moins
            self.dx=3    # dimension de la photo depuis le centre
            self.dy=3

        if self.type==1:
            # creation d'une pile (générateur)
            self.cx.append(self.x)
            self.cy.append(self.y-5)   # pole +
            self.cx.append(self.x)   # pole -
            self.cy.append(self.y+5)
            self.etat.append(1)     # pole + (débranché à l'initialisation)
            self.etat.append(0)     # pole -
            self.dx=3
            self.dy=6


        if self.type==2:
            # creation d'un commutateur
            self.cx.append(self.x-1)
            self.cy.append(self.y+4)
            self.cx.append(self.x)
            self.cy.append(self.y+4)
            self.cx.append(self.x+1)
            self.cy.append(self.y+4)
            self.etat.append(2)      # pas relié
            self.etat.append(2)
            self.etat.append(2)
            self.etat.append(0)    # position du commutateur
            self.etat2=0
            self.dx=3
            self.dy=5
            p1=Point(self.cx[0],self.cy[0],coul="goldenrod3")
            p1.trace()
            f1=Fil(p1,coul="goldenrod3")
            liste_fils.append(f1)
            liste_points.append(p1)
            p2=Point(self.cx[1],self.cy[1],coul="goldenrod3")
            #print("f1 = ",len(f1.liste))
            #pas_change=False
            f1.efface()
            f1.ajoute(p2)
            liste_points.append(p2)
            f1.trace()
        if self.type==3:
            # creation d'un condensateur
            self.cx.append(self.x-3)
            self.cy.append(self.y)   # pole
            self.cx.append(self.x+3)   # pole
            self.cy.append(self.y)
            self.etat.append(charge_0)     # 0 : fil collecteur pas passé par le plus, 1 : passé par le plus
            self.etat.append(1-charge_0)     # 0: fil collecteur descendu à 0 , 1 : attente de passage par 0
            charge_0=0                        # pour ne charger qu'un condensateur pour astable
            # pour déclencher un cycle de charge lente
            self.dx=3
            self.dy=1

        if self.type==4 or self.type==5:
            # creation d'un 74LS00 ou d'un 74LS32
            self.cx.append(self.x-3)
            self.cy.append(self.y-2)   # alim +
            self.cx.append(self.x+3)   # alim -
            self.cy.append(self.y+2)   #

            self.cx.append(self.x-3)   # e1
            self.cy.append(self.y+2)   #
            self.cx.append(self.x-2)  # e1'
            self.cy.append(self.y+2)   #
            self.cx.append(self.x-1)  # s1
            self.cy.append(self.y+2)   #

            self.cx.append(self.x)   # e2
            self.cy.append(self.y+2)   #
            self.cx.append(self.x+1)  # e2'
            self.cy.append(self.y+2)   #
            self.cx.append(self.x+2)  # s2
            self.cy.append(self.y+2)   #

            self.cx.append(self.x-2)   # e3
            self.cy.append(self.y-2)   #
            self.cx.append(self.x-1)  # e3'
            self.cy.append(self.y-2)   #
            self.cx.append(self.x)  # s3
            self.cy.append(self.y-2)   #

            self.cx.append(self.x+1)   # e4
            self.cy.append(self.y-2)   #
            self.cx.append(self.x+2)  # e4'
            self.cy.append(self.y-2)   #
            self.cx.append(self.x+3)  # s4
            self.cy.append(self.y-2)   #


            self.etat.append(0)     # etat de s1 (0)
            self.etat.append(0)     # etat de s2 (0)
            self.etat.append(0)     # etat de s3 (0)
            self.etat.append(0)     # etat de s4 (0)


            self.dx=3
            self.dy=2

        if self.type==6:      # agfficheur double
            can1.delete(self.cmp_des)
            #self.img=imga[icompolu]
            self.cmp_des1=can1.create_image((self.x-4)*paspixel,self.y*paspixel,image=affg[0])
            self.cmp_des2=can1.create_image((self.x+4)*paspixel,self.y*paspixel,image=affd[0])

            self.cx.append(self.x+7)
            self.cy.append(self.y+2)   # 1
            self.cx.append(self.x+7)
            self.cy.append(self.y+1)   # 2
            self.cx.append(self.x+7)
            self.cy.append(self.y)   # 4
            self.cx.append(self.x+7)
            self.cy.append(self.y-1)   # 8
            self.cx.append(self.x+7)
            self.cy.append(self.y-2)   # 16
            self.cx.append(self.x+7)
            self.cy.append(self.y-3)   # 32
            self.cx.append(self.x+7)
            self.cy.append(self.y-4)   # 64

            self.cx.append(self.x+2)
            self.cy.append(self.y+4)   # + afficheur
            self.cx.append(self.x+5)
            self.cy.append(self.y+4)   # - afficheur

            self.dx=4
            self.dy=3







    def suppr(self):
        #print("debut objet composant detruit")
        if self.type != 6:
            can1.delete(self.cmp_des)
        #print("objet composant detruit")
        if self.type==2:
            it=-1
            if self.etat2==0:
                for i in range(len(liste_fils)):
                    if (liste_fils[i].liste[0].x==self.cx[0] and \
                    liste_fils[i].liste[0].y==self.cy[0] and \
                    liste_fils[i].liste[1].x==self.cx[1] and \
                    liste_fils[i].liste[1].y==self.cy[1]) :
                        it=i
                        #print("fil trouvé commut vers etat 1")
                liste_fils[it].suppr()
                del(liste_fils[it])
            if self.etat2==1:
                for i in range(len(liste_fils)):
                    if (liste_fils[i].liste[0].x==self.cx[1] and \
                    liste_fils[i].liste[0].y==self.cy[1] and \
                    liste_fils[i].liste[1].x==self.cx[2] and \
                    liste_fils[i].liste[1].y==self.cy[2]) :
                        it=i
                        #print("fil trouvé commut vers etat 0")
                liste_fils[it].suppr()
                del(liste_fils[it])
        if self.type==6 :  # afficheur
            can1.delete(self.cmp_des1)
            can1.delete(self.cmp_des2)



    def chet(self, etat2=0):
        if self.type==2:
            self.etat2=etat2
            #print("chet etat2= ",self.etat2)
        return

    def changt_etat(self):   # reaction au changement d'état de la borne i sur les autres bornes (i necessaire ?)
        if self.type==0:  # transistor
            if(self.etat[2]*self.etat[4])>=1:   # transistor alimenté correctement
                if self.etat[0]==1 and self.etat[1]==2:  # + sur 100 K et pas de condensateur (transistor passant)
                    self.etat[3]=0
                    can1.delete(self.cmp_des)
                    self.img=imgb[self.type]
                    self.cmp_des=can1.create_image(self.x*paspixel,self.y*paspixel,image=self.img)
                    #print("passant jaune")
                elif self.etat[1]==0:                     # condensateur déchargé sur la base bleue
                    self.etat[3]=1
                     # bloqué
                    can1.delete(self.cmp_des)
                    self.img=imga[self.type]
                    self.cmp_des=can1.create_image(self.x*paspixel,self.y*paspixel,image=self.img)
                    #print("bloqué bleu")
                elif self.etat[1]==1:                      # condensateur chargé sur la bas bleue
                    self.etat[3]=0
                    can1.delete(self.cmp_des)
                    self.img=imgb[self.type]
                    self.cmp_des=can1.create_image(self.x*paspixel,self.y*paspixel,image=self.img)                    # passant
                    #print("passant bleu")
                elif self.etat[0]==0 and self.etat[1]==2: # 0 ou rien sur la 100 K. (transistor bloqué)
                    self.etat[3]=1
                    can1.delete(self.cmp_des)
                    self.img=imga[self.type]
                    self.cmp_des=can1.create_image(self.x*paspixel,self.y*paspixel,image=self.img)
                    #print("bloqué jaune")
            else:
                print("Le transistor x = ",self.x," y = ",self.y,"n'est pas correctement alimenté")

        if self.type==1:  # générateur
            if tension_on:
                self.etat[0]=1
            else:
                self.etat[0]=0

        if self.type==2:  # commutateur
            if self.etat2==0:
                #print("debut changt etat type 2 etat 0")
                can1.delete(self.cmp_des)
                self.etat2=1
                self.img=imgb[self.type]
                self.cmp_des=can1.create_image(self.x*paspixel,self.y*paspixel,image=self.img)
                # recherche de la connexion du commutateur à retirer
                it=-1
                for i in range(len(liste_fils)):
                    if (liste_fils[i].liste[0].x==self.cx[0] and \
                    liste_fils[i].liste[0].y==self.cy[0] and \
                    liste_fils[i].liste[1].x==self.cx[1] and \
                    liste_fils[i].liste[1].y==self.cy[1]) :
                        it=i
                        #print("fil trouvé commut vers etat 1")
                liste_fils[it].suppr()
                del(liste_fils[it])
                # mise en place de l'autre connexion
                p1=Point(self.cx[1],self.cy[1],coul="goldenrod3")
                p1.trace()
                f1=Fil(p1,coul="goldenrod3")
                liste_fils.append(f1)
                liste_points.append(p1)
                p2=Point(self.cx[2],self.cy[2],coul="goldenrod3")
            #print("f1 = ",len(f1.liste))
            #pas_change=False
                f1.efface()
                f1.ajoute(p2)
                f1.trace()


            else:
                #print("debut changt etat type 2 etat 1")
                can1.delete(self.cmp_des)
                self.etat2=0
                self.img=imga[self.type]
                self.cmp_des=can1.create_image(self.x*paspixel,self.y*paspixel,image=self.img)
                it=-1
                for i in range(len(liste_fils)):
                    if (liste_fils[i].liste[0].x==self.cx[1] and \
                    liste_fils[i].liste[0].y==self.cy[1] and \
                    liste_fils[i].liste[1].x==self.cx[2] and \
                    liste_fils[i].liste[1].y==self.cy[2]) :
                        it=i
                        #print("fil trouvé commut vers etat 0")
                liste_fils[it].suppr()
                del(liste_fils[it])
                # mise en place de l'autre connexion
                p1=Point(self.cx[0],self.cy[0],coul="goldenrod3")
                p1.trace()
                f1=Fil(p1,coul="goldenrod3")
                liste_fils.append(f1)
                liste_points.append(p1)
                p2=Point(self.cx[1],self.cy[1],coul="goldenrod3")
            #print("f1 = ",len(f1.liste))
            #pas_change=False
                f1.efface()
                f1.ajoute(p2)
                f1.trace()












def dessine():
        global img,nb
        for i in range (2*dimx//paspixel):
            can1.create_line(-dimx+i*paspixel,-dimy,-dimx+i*paspixel,dimy,fill=coul_maillage,width=ep_maillage)
        for i in range (2*dimy//paspixel):
            can1.create_line(-dimx,-dimy+i*paspixel,dimx,-dimy+i*paspixel,fill=coul_maillage,width=ep_maillage)

        #for i in range (nb):
         #   can1.create_image(i*200,i*200,image=img[i])



def but_1(event):
        "debut d'un fil"
        global f1, ptdebcree, numero_action,ifilselect, ipointselect,img,icompo, nb_composants, pas_change,index,icompolu
        if numero_action == 0:   # mise en place des composants
            posx=event.x+depla_x
            posy=event.y+depla_y
            pointx=(posx+paspixel//2)//paspixel
            pointy=(posy+paspixel//2)//paspixel       # non superposition de 2 composants au meme point
            test_egal=0
            for i in range(nb_types_cmp):
                for j in range(len(comp[i])):
                    if (comp[i][j].x==pointx and comp[i][j].y==pointy):
                        test_egal=1    # il y a déjà un composant à cet endroit

            if test_egal==0 :
                compo=Composant(icompolu,pointx,pointy)
                comp[icompolu].append(compo)
                pas_change=False
                nb_composants[icompolu]+=1
                if icompolu==0:
                    drapeau_base.append(0)

        if numero_action == 1:   # tracé des fils
            # tracé du premier point d'un fil
            if(not(ok_clic)):
                return
            temporisation_clic()
            ptdebcree=False
            posx=event.x+depla_x
            posy=event.y+depla_y
            pointx=(posx+paspixel//2)//paspixel
            pointy=(posy+paspixel//2)//paspixel
            p1=Point(pointx,pointy,coul="goldenrod3")
            p1.trace()
            f1=Fil(p1,coul="goldenrod3")
            liste_fils.append(f1)
            liste_points.append(p1)
            pas_change=False
            ptdebcree=True

        elif numero_action == 2:
            # commutation
            posx=event.x+depla_x
            posy=event.y+depla_y
            pointx=(posx+paspixel//2)//paspixel
            pointy=(posy+paspixel//2)//paspixel
           # print("pointx = ",pointx," pointy = ",pointy)

            icompolu2=2                    # on force temporairement : action sur le commutateur
            if icompolu2==2:
                for i in range(nb_composants[icompolu2]):
                    c=comp[icompolu2][i]
                    if pointx >= c.x-c.dx and pointx <= c.x+c.dx and pointy >= c.y -c.dy and pointy <= c.y + c.dy : # on est sur un composant
                        c.changt_etat()
                        for h in range(len(liste_fils)):
                            for k in range(len(liste_fils[h].liste_lignes)):
                                can1.tag_raise(liste_fils[h].liste_lignes[k])
                                can1.tag_raise(liste_fils[h].liste[0].cercle)
                                can1.tag_raise(liste_fils[h].liste[-1].cercle)
                cal_con2()













def shift_but_1(event):
        "poursuite d'un fil ou fin du fil"
        global ptdebcree, f1, numero_action
        if (ptdebcree) and numero_action==1:  # on a cliqué pour créer un point, on attend de finir ce point
            if(not(ok_clic)):
                return
            temporisation_clic()
            #print("ok shft-but_1")
            posx=event.x+depla_x
            posy=event.y+depla_y
            pointx=(posx+paspixel//2)//paspixel
            pointy=(posy+paspixel//2)//paspixel
            if abs(f1.liste[-1].x - pointx) > abs(f1.liste[-1].y-pointy) :
                # le tracé est plutot suivant x
                pointy=f1.liste[-1].y   # on projette
            else:
                pointx=f1.liste[-1].x
            p2=Point(pointx,pointy,coul="goldenrod3")
            #print("f1 = ",len(f1.liste))
            pas_change=False
            f1.efface()
            f1.ajoute(p2)
            f1.trace()
            #for itempo in range(tempo):
            #    xtempo=10
            #    xtempo=xtempo*xtempo
            #    xtempo=xtempo/xtempo

        if numero_action==2: # mise en place d'un voltmetre
            posx=event.x+depla_x
            posy=event.y+depla_y
            px=(posx+paspixel//2)//paspixel
            py=(posy+paspixel//2)//paspixel
            # recherche d'un eventuel fil sous ce point
            nbfils=len(liste_fils)
            itrouve=-1
            #print("nbfils = ",nbfils)
            for j in range(nbfils):
        #p1i=liste_fils[i].liste[0]
        #p2i=liste_fils[i].liste[-1]
                # on regarde si le voltmetre se trouve entre les extrémités du segment entre deux coudes du fil j
                for k in range(len(liste_fils[j].liste)-1):
                    p1j=liste_fils[j].liste[k]
                    p2j=liste_fils[j].liste[k+1]
                    if (((px-p1j.x)*(px-p2j.x)<0 and py==p1j.y and py==p2j.y)or \
                       ((py-p1j.y)*(py-p2j.y)<0 and px==p1j.x and px==p2j.x)) and itrouve==-1:
                        # le voltmetre est sur le fil j et pas à une extremite
                        itrouve=1
                        v=Voltmetre(px,py,j,coul="aqua")
                        v.trace()
                        liste_volt.append(v)
                        cal_con2()







def but(event):
    print("ok faux but_1")

def scroll(event):
    global depla_x,depla_y
    #print("dans scroll depla_x =",depla_x," depla_y = ",depla_y)
    arrow=event.keysym
    if arrow=='Right' and depla_x<dimx-depla-fen1x :
        depla_x+=depla
        can1.xview_scroll(1, "units")
    elif arrow=='Left'  and depla_x>-dimx+depla :
        depla_x-=depla
        can1.xview_scroll(-1, "units")
    elif arrow=='Down'  and depla_y<dimy-depla-fen1y :
        depla_y+=depla
        can1.yview_scroll(1, "units")
    elif arrow=='Up'  and depla_y>-dimy+depla :
        depla_y-=depla
        can1.yview_scroll(-1, "units")


def but_3(event):
    global ptdebcree, numero_action,ifilselect, ipointselect
    if numero_action==0:
        posx=event.x+depla_x
        posy=event.y+depla_y
        pointx=(posx+paspixel//2)//paspixel
        pointy=(posy+paspixel//2)//paspixel
        idel=-1
        jdel=-1
        for i in range(nb_types_cmp):
            for j in range(len(comp[i])):
                c=comp[i][j]
                #print("i = ",i," j = ",j)
                if pointx>=c.x-c.dx and pointx<=c.x+c.dx and pointy>=c.y-c.dy and pointy<=c.y+c.dy:
                    #print("on supprime ce composant")
                    idel=i
                    jdel=j

        if idel>=0 and jdel>=0 :
            #print("idel = ",idel," jdel = ",jdel)
            pas_change=False
            comp[idel][jdel].suppr()
            #print("suppr")
            del(comp[idel][jdel])
            #print("del")
            nb_composants[idel]-=1
            if idel==0:   # on detruit le transistor jdel
                del(drapeau_base[jdel])



    if numero_action==1:
            # sélection d'un fil

            ptdebcree=False
            #print("selection")
            trouve=False
            if ifilselect>=0:
                f1=liste_fils[ifilselect]
                f1.change_coul("goldenrod3")
            posx=event.x+depla_x
            posy=event.y+depla_y
            pointx=(posx+paspixel//2)//paspixel
            pointy=(posy+paspixel//2)//paspixel
            pointtrouve=False
            for i in range (len(liste_fils)):
                if len(liste_fils[i].liste)==1:
                    if pointx-liste_fils[i].liste[0].x==0 and pointy-liste_fils[i].liste[0].y==0 :
                        ifilselect=i
                        #print("fil point trouvé i=",i)
                        trouve=True
                        pointtrouve=True
                        break
                else:
                    #print("select fil ",i," : nbre de points du fil = ",len(liste_fils[i].liste))

                    for j in range (len(liste_fils[i].liste)-1):
                        if (((pointx-liste_fils[i].liste[j].x)*(pointx-liste_fils[i].liste[j+1].x)<=0)and\
                        ((pointy-liste_fils[i].liste[j].y)*(pointy-liste_fils[i].liste[j+1].y)<=0)):
                            ifilselect=i
                            #print(" fil trouve i=",i)
                            trouve=True
                            break
            if trouve :
                print("ifilselect = ",ifilselect)
                f1=liste_fils[ifilselect]
                #f1.efface()
                #f1.coul="red"
                #f1.trace()
                f1.change_coul("red")
            else:
                if ifilselect>=0:
                    f1=liste_fils[ifilselect]
                    f1.change_coul("goldenrod3")
                    ifilselect=-1
                if ipointselect>=0:
                    p1=liste_points[ipointselect]
                    p1.change_coul("goldenrod3")
                    ipointselect=-1
            if pointtrouve :
                for i in range(len(liste_points)):
                   if(liste_points[i].x==pointx and liste_points[i].y==pointy):
                        ipointselect=i
                        p1=liste_points[ipointselect]
                        p1.change_coul("red")





def shift_but_3(event):
    global ifilselect,numero_action, ipointselect
    if (ifilselect>=0) and (numero_action==1):
        f1=liste_fils[ifilselect]
        f1.suppr()
        del(liste_fils[ifilselect])
        pas_change=False
        ifilselect=-1
    if numero_action==2:   # suppression d'un voltmetre
        posx=event.x+depla_x
        posy=event.y+depla_y
        px=(posx+paspixel//2)//paspixel
        py=(posy+paspixel//2)//paspixel
        # recherche d'un eventuel fil sous ce point
        itrouve=-1
        for i in range(len(liste_volt)):
            if liste_volt[i].x==px and liste_volt[i].y==py:
                itrouve=i
        if itrouve!= -1:
            liste_volt[itrouve].suppr()
            del(liste_volt[itrouve])

def creer_connexions():
    global liste_connect,drapeau_plus,drapeau_moins
    # on balaye les fils pour voir s'ils ont des noeuds en commun. ou un neud au milieu d'un autre fil
    nbfils=len(liste_fils)
    #print("nombre de fils = ",nbfils)
    for i in range(nbfils):
        drapeau_plus.append([])
        drapeau_moins.append([])   # drapeaux pour l'état prioritaire de la connexion i
        dra_con.append([])         # etat global de la connexion

    connect=[]
    liste_connect=[]
    deja=[]
    numero_connexion=nbfils
    for i in range(nbfils):
        deja.append(i)
        connect.append(0)
        connect[i]=[]
        liste_connect.append([i])
        for j in range(nbfils):
            connect[i].append(-1) # a priori pas connectés
    for i in range(nbfils-1):
        p1i=liste_fils[i].liste[0]
        p2i=liste_fils[i].liste[-1]
        for j in range(i+1,nbfils):
            if i!=j:    # on traite
                # on regarde si le debut ou la fin du fil j se trouve entre les extrémités du segment entre deux coudes du fil i
                for k in range(len(liste_fils[j].liste)-1):
                    p1j=liste_fils[j].liste[k]
                    p2j=liste_fils[j].liste[k+1]
                    if ((p1i.x-p1j.x)*(p1i.x-p2j.x)<=0 and p1i.y==p1j.y and p1i.y==p2j.y)or \
                       ((p1i.y-p1j.y)*(p1i.y-p2j.y)<=0 and p1i.x==p1j.x and p1i.x==p2j.x)or \
                       ((p2i.x-p1j.x)*(p2i.x-p2j.x)<=0 and p2i.y==p1j.y and p2i.y==p2j.y)or \
                       ((p2i.y-p1j.y)*(p2i.y-p2j.y)<=0 and p2i.x==p1j.x and p2i.x==p2j.x) : # une extrémité i est entre 2 noeuds j
                        #print("Ok connect 1 i = ",i," j = ",j," k = ",k)

                        if(deja[i]>=0 or deja[j]>=0):
                            if(deja[i]>=0 and deja[j]>=0):
                                if deja[i]<deja[j]:
                                    c=deja[i]
                                    d=deja[j]
                                    #print("deja[",i,"] = ",deja[i])
                                    #print("deja[",j,"] = ",deja[j])
                                    #print("liste_connect partie deja 1     1-1",liste_connect)
                                    temporaire=[]
                                    long=len(liste_connect[deja[j]])
                                    for t in range(len(liste_connect[deja[j]])):
                                        temporaire.append(liste_connect[deja[j]][t])
                                        liste_connect[deja[i]].append(liste_connect[deja[j]][t])
                                        connect[i][liste_connect[deja[j]][t]]=c
                                        connect[liste_connect[deja[j]][t]][i]=c
                                    for t in range(long):
                                        #print("A - deja[temporaire[t]] = ", deja[temporaire[t]]," temporaire[t] = ",temporaire[t])
                                        deja[temporaire[t]]=c
                                        #print("B - deja[temporaire[t]] = ", deja[temporaire[t]]," temporaire[t] = ",temporaire[t])




                                    #print("connect[i][j]  boucle 1 = ",connect)

                                    liste_connect[d]=[]
                                    #print("liste_connect partie 1-2",liste_connect)
                                if deja[j]<deja[i]:
                                    c=deja[i]
                                    d=deja[j]
                                    #print("deja[",i,"] = ",deja[i])
                                    #print("deja[",j,"] = ",deja[j])
                                    #print("liste_connect partie deja 2    1-1",liste_connect)
                                    temporaire=[]
                                    long=len(liste_connect[deja[i]])
                                    for t in range(len(liste_connect[deja[i]])):
                                        temporaire.append(liste_connect[deja[i]][t])
                                        liste_connect[deja[j]].append(liste_connect[deja[i]][t])
                                        connect[j][liste_connect[deja[i]][t]]=d
                                        connect[liste_connect[deja[i]][t]][j]=d
                                    #for t in range(len(liste_connect[deja[i]])):
                                    #    deja[liste_connect[deja[i]][t]]=d
                                    for t in range(long):
                                        #print("A - deja[temporaire[t]] = ", deja[temporaire[t]]," temporaire[t] = ",temporaire[t])
                                        deja[temporaire[t]]=d
                                        #print("B - deja[temporaire[t]] = ", deja[temporaire[t]]," temporaire[t] = ",temporaire[t])



                                    #print("connect[i][j]  boucle 1 2 3 = ",connect)

                                        #liste_connect[c].append(c)
                                    #del(liste_connect[deja[j]])
                                    liste_connect[c]=[]
                                    #print("liste_connect partie 1-2-3",liste_connect)



    for i in range(nbfils-1):
        for k in range(len(liste_fils[i].liste)-1):
            p1i=liste_fils[i].liste[k]
            p2i=liste_fils[i].liste[k+1]

            for j in range(i+1,nbfils):
                if i!=j:    # on traite
                # on regarde si le debut ou la fin du fil j se trouve entre les extrémités du segment entre deux coudes du fil i
                    p1j=liste_fils[j].liste[0]
                    p2j=liste_fils[j].liste[-1]
                    if ((p1j.x-p1i.x)*(p1j.x-p2i.x)<=0 and p1j.y==p1i.y and p1j.y==p2i.y)or \
                       ((p1j.y-p1i.y)*(p1j.y-p2i.y)<=0 and p1j.x==p1i.x and p1j.x==p2i.x)or \
                       ((p2j.x-p1i.x)*(p2j.x-p2i.x)<=0 and p2j.y==p1i.y and p2j.y==p2i.y)or \
                       ((p2j.y-p1i.y)*(p2j.y-p2i.y)<=0 and p2j.x==p1i.x and p2j.x==p2i.x) : # une extrémité i est entre 2 noeuds j
                        #print("Ok connect 2 i = ",i," j = ",j," k = ",k)

                        if(deja[i]>=0 or deja[j]>=0):
                            if(deja[i]>=0 and deja[j]>=0):
                                if deja[i]<deja[j]:
                                    c=deja[i]
                                    d=deja[j]
                                    #print("deja[",i,"] = ",deja[i])
                                    #print("deja[",j,"] = ",deja[j])
                                    #print("liste_connect partie 2-1  deb ",liste_connect)
                                    temporaire=[]
                                    long=len(liste_connect[deja[j]])
                                    for t in range(len(liste_connect[deja[j]])):
                                        temporaire.append(liste_connect[deja[j]][t])
                                        liste_connect[deja[i]].append(liste_connect[deja[j]][t])
                                        connect[i][liste_connect[deja[j]][t]]=c
                                        connect[liste_connect[deja[j]][t]][i]=c
                                    #for t in range(len(liste_connect[deja[j]])):
                                    #    print("A - liste_connect[deja[j]][t] = ",liste_connect[deja[j]][t]," deja = ",deja[liste_connect[deja[j]][t]])
                                    #    deja[liste_connect[deja[j]][t]]=c
                                    #    print("B - liste_connect[deja[j]][t] = ",liste_connect[deja[j]][t]," deja = ",deja[liste_connect[deja[j]][t]])
                                    for t in range(long):
                                        #print("A - deja[temporaire[t]] = ", deja[temporaire[t]]," temporaire[t] = ",temporaire[t])
                                        deja[temporaire[t]]=c
                                        #print("B - deja[temporaire[t]] = ", deja[temporaire[t]]," temporaire[t] = ",temporaire[t])




                                    #print("connect[i][j]  boucle 2 = ",connect)

                                        #liste_connect[c].append(c)
                                    #del(liste_connect[deja[j]])
                                    liste_connect[d]=[]
                                    #print("liste_connect partie 2-1  fin ",liste_connect)
                                if deja[i]>deja[j]:
                                    c=deja[j]
                                    d=deja[i]
                                    #print("deja[",i,"] = ",deja[i])
                                    #print("deja[",j,"] = ",deja[j])
                                    #print("liste_connect partie 2-2  deja 2 ",liste_connect)
                                    temporaire=[]
                                    long=len(liste_connect[deja[i]])
                                    for t in range(len(liste_connect[deja[i]])):
                                        temporaire.append(liste_connect[deja[i]][t])
                                        #print("liste_connect[deja[i]][t] ",liste_connect[deja[i]][t]," t = ",t)
                                        #print("deja[i] = ",deja[i],' i = ',i)
                                        liste_connect[deja[j]].append(liste_connect[deja[i]][t])
                                        connect[liste_connect[deja[i]][t]][j]=c
                                        connect[j][liste_connect[deja[i]][t]]=c
                                    for t in range(long):
                                        #print("A - deja[temporaire[t]] = ", deja[temporaire[t]]," temporaire[t] = ",temporaire[t])
                                        deja[temporaire[t]]=c
                                        #print("B - deja[temporaire[t]] = ", deja[temporaire[t]]," temporaire[t] = ",temporaire[t])

                                    #for t in range(len(liste_connect[deja[i]])):
                                    #    deja[liste_connect[deja[i]][t]]=c


                                    #print("connect[i][j]  boucle 3 = ",connect)

                                        #liste_connect[c].append(c)
                                    #del(liste_connect[deja[j]])
                                    liste_connect[d]=[]
                                    #print("liste_connect partie 2-3",liste_connect)


    #print("connexions : ",liste_connect)
    #print("connect[i][j] = ",connect)
def tension_on():
    global tension_on_1
    if tension_on_1:
        tension_on_1=False
        for i in range(nb_composants[1]):
            c=comp[1][i]
            c.etat[0]=0     # piles désactivées
        print("Piles OFF")

    else:
        tension_on_1=True
        for i in range(nb_composants[1]):
            c=comp[1][i]
            c.etat[0]=1     # piles activées
            print("pile ON")
        #calcul_circuit_01()
def cal_con():
    #print("debut calc_con")
    global drapeau_plus, drapeau_moins, dra_con,liste_connect,comp,Tplus,Tmoins,drap_cond_0,drap_cond_1, drap_cond1, drap_cond2, \
    appel, Tmoins00, Tmoins00, Tplus32, Tmoins32
    appel=appel+1
    #print("appel cal_con= ",appel,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    #print("longueur connect = ",len(liste_connect))
    for k in range(len(comp[0])):
            drapeau_base[k]=0
    Tplus=[]
    Tmoins=[]
    drapeau_plus=[]
    drapeau_moins=[]
    drapeau_basej=[]   # jaune
    drapeau_baseb=[]  # bleu
    drapeau_coll=[]
    drapeau_cond_0=[]  # condensateur coté base bleue cx[0] cond
    drapeau_cond_1=[]  # condensateur coté base bleue cx[1] cond
    coll=[]  # definit si une connexion de collecteurs est à 0
    drapeau_00=[]
    Tplus00=[]
    Tmoins00=[]
    drapeau_32=[]
    Tplus32=[]
    Tmoins32=[]
    Tplusaff=[]
    Tmoinsaff=[]
    drapeau_aff=[]
    if len(liste_connect)<1:
        print("Aucune connexion")
        return
    for i in range(len(liste_connect)):  # boucle sur les connexions
        coll.append(1)
    for i in range(len(liste_connect)):  # boucle sur les connexions

        for j in range(len(liste_connect[i])): # boucle sur les fils des connexions
            #print("j = ",j)

            for k in range(nb_composants[1]):   # générateurs
                #print("i = ",i," j = ",j," k = ",k)
                drapeau_plus.append(-1)
                drapeau_moins.append(-1)
                if ((comp[1][k].cx[0]==liste_fils[liste_connect[i][j]].liste[0].x and comp[1][k].cy[0]==liste_fils[liste_connect[i][j]].liste[0].y )\
                or (comp[1][k].cx[0]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[1][k].cy[0]==liste_fils[liste_connect[i][j]].liste[-1].y)) and comp[1][k].etat[0]==1:
                    drapeau_plus[k]=i   #  cette connexion comporte un pole + de pile
                    #print("pole + trouvé : ",i," ",k)
                if ((comp[1][k].cx[1]==liste_fils[liste_connect[i][j]].liste[0].x and comp[1][k].cy[1]==liste_fils[liste_connect[i][j]].liste[0].y) \
                or (comp[1][k].cx[1]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[1][k].cy[1]==liste_fils[liste_connect[i][j]].liste[-1].y)) and comp[1][k].etat[0]==1:
                    drapeau_moins[k]=i   #  cette connexion comporte un pole - de pile
                    #print("pole - trouvé : ",i," ",k)


            #for k in range(nb_composants[0]):   # transistors
            for k in range(len(comp[0])):
                Tplus.append(-1)
                Tmoins.append(-1)
                drapeau_baseb.append(-1)
                drapeau_basej.append(-1)
                drapeau_coll.append(-1)
                if (comp[0][k].cx[2]==liste_fils[liste_connect[i][j]].liste[0].x and comp[0][k].cy[2]==liste_fils[liste_connect[i][j]].liste[0].y) \
                or  (comp[0][k].cx[2]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[0][k].cy[2]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_plus_t[i]+=1   #  le plus du transistor est sur la connexion i
                    #print("T+ trouvé ",i," ",k)
                    Tplus[k]=i
                    #if drapeau_plus[i]>=1:
                    #    comp[0][k].etat[2]=1
                if (comp[0][k].cx[4]==liste_fils[liste_connect[i][j]].liste[0].x and comp[0][k].cy[4]==liste_fils[liste_connect[i][j]].liste[0].y) \
                or (comp[0][k].cx[4]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[0][k].cy[4]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_moins_t[i]+=1   #  le moins du transistor est sur le - d'une pile
                    #print("T- trouvé ",i," ",k)
                    Tmoins[k]=i
                    #if drapeau_moins[i]>=1:
                    #    comp[0][k].etat[4]=1
                if (comp[0][k].cx[0]==liste_fils[liste_connect[i][j]].liste[0].x and comp[0][k].cy[0]==liste_fils[liste_connect[i][j]].liste[0].y) \
                or (comp[0][k].cx[0]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[0][k].cy[0]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_moins_t[i]+=1   #  le moins du transistor est sur le - d'une pile
                    drapeau_basej[k]=i
                    #print("base trouvée ",i," ",k)
                    #if drapeau_plus[i]>=1:
                    #    comp[0][k].etat[0]=1
                    #if drapeau_moins[i]>=1:
                    #    comp[0][k].etat[0]=0
                if (comp[0][k].cx[1]==liste_fils[liste_connect[i][j]].liste[0].x and comp[0][k].cy[1]==liste_fils[liste_connect[i][j]].liste[0].y) \
                or (comp[0][k].cx[1]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[0][k].cy[1]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_moins_t[i]+=1   #  le moins du transistor est sur le - d'une pile
                    drapeau_baseb[k]=i
                    #print("base trouvée ",i," ",k)
                if (comp[0][k].cx[3]==liste_fils[liste_connect[i][j]].liste[0].x and comp[0][k].cy[3]==liste_fils[liste_connect[i][j]].liste[0].y) \
                or (comp[0][k].cx[3]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[0][k].cy[3]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_moins_t[i]+=1   #  le moins du transistor est sur le - d'une pile
                    drapeau_coll[k]=i
                    #print("collecteur relié connexion : ",i," transistor : ",k)
                    #coll[i]=0   # il y aau moins un collecteur à 0 sur cette connexion
            for k in range(nb_composants[3]):    # condensateur 47 microfarads
                drapeau_cond_0.append(-1)
                drapeau_cond_1.append(-1)
                if (comp[3][k].cx[0]==liste_fils[liste_connect[i][j]].liste[0].x and comp[3][k].cy[0]==liste_fils[liste_connect[i][j]].liste[0].y) \
                or (comp[3][k].cx[0]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[3][k].cy[0]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    drapeau_cond_0[k]=i
                    #print("condens ",k,": cx[0] : connexion ",i)
                if (comp[3][k].cx[1]==liste_fils[liste_connect[i][j]].liste[0].x and comp[3][k].cy[1]==liste_fils[liste_connect[i][j]].liste[0].y) \
                or (comp[3][k].cx[1]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[3][k].cy[1]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    drapeau_cond_1[k]=i
                    #print("condens ",k," : cx[1] : connexion",i)

            for k in range(nb_composants[4]):   # 74LS00
                Tplus00.append(-1)
                Tmoins00.append(-1)
                drapeau_00.append([])    # ajout du composant k
                for es in range(4):
                    drapeau_00[k].append([])  #  ajout des 4 portes
                    for inp in range(3):
                        drapeau_00[k][es].append(-1)  # ajout de 2 entrees et d'une sortie à chaque porte
                if (comp[4][k].cx[0]==liste_fils[liste_connect[i][j]].liste[0].x and comp[4][k].cy[0]==liste_fils[liste_connect[i][j]].liste[0].y) \
                    or  (comp[4][k].cx[0]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[4][k].cy[0]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_plus_t[i]+=1   #  le plus du transistor est sur la connexion i
                    #print("T+ trouvé ",i," ",k)
                        Tplus00[k]=i
                    #if drapeau_plus[i]>=1:
                    #    comp[0][k].etat[2]=1
                if (comp[4][k].cx[1]==liste_fils[liste_connect[i][j]].liste[0].x and comp[4][k].cy[1]==liste_fils[liste_connect[i][j]].liste[0].y) \
                    or  (comp[4][k].cx[1]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[4][k].cy[1]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_plus_t[i]+=1   #  le plus du transistor est sur la connexion i
                    #print("T+ trouvé ",i," ",k)
                        Tmoins00[k]=i

                for es in range(4):
                    for inp in range(3):
                        if (comp[4][k].cx[2+es*3+inp]==liste_fils[liste_connect[i][j]].liste[0].x and comp[4][k].cy[2+es*3+inp]==liste_fils[liste_connect[i][j]].liste[0].y) \
                        or  (comp[4][k].cx[2+es*3+inp]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[4][k].cy[2+es*3+inp]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_plus_t[i]+=1   #  le plus du transistor est sur la connexion i
                    #print("T+ trouvé ",i," ",k)
                            drapeau_00[k][es][inp]=i
                    #if drapeau_plus[i]>=1:
                    #    comp[0][k].etat[2]=1


            for k in range(nb_composants[5]):   # 74LS32
                Tplus32.append(-1)
                Tmoins32.append(-1)
                drapeau_32.append([])    # ajout du composant k
                for es in range(4):
                    drapeau_32[k].append([])  #  ajout des 4 portes
                    for inp in range(3):
                        drapeau_32[k][es].append(-1)  # ajout de 2 entrees et d'une sortie à chaque porte
                if (comp[5][k].cx[0]==liste_fils[liste_connect[i][j]].liste[0].x and comp[5][k].cy[0]==liste_fils[liste_connect[i][j]].liste[0].y) \
                    or  (comp[5][k].cx[0]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[5][k].cy[0]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_plus_t[i]+=1   #  le plus du transistor est sur la connexion i
                    #print("T+ trouvé ",i," ",k)
                        Tplus32[k]=i
                    #if drapeau_plus[i]>=1:
                    #    comp[0][k].etat[2]=1
                if (comp[5][k].cx[1]==liste_fils[liste_connect[i][j]].liste[0].x and comp[5][k].cy[1]==liste_fils[liste_connect[i][j]].liste[0].y) \
                    or  (comp[5][k].cx[1]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[5][k].cy[1]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_plus_t[i]+=1   #  le plus du transistor est sur la connexion i
                    #print("T+ trouvé ",i," ",k)
                        Tmoins32[k]=i

                for es in range(4):
                    for inp in range(3):
                        if (comp[5][k].cx[2+es*3+inp]==liste_fils[liste_connect[i][j]].liste[0].x and comp[5][k].cy[2+es*3+inp]==liste_fils[liste_connect[i][j]].liste[0].y) \
                        or  (comp[5][k].cx[2+es*3+inp]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[5][k].cy[2+es*3+inp]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_plus_t[i]+=1   #  le plus du transistor est sur la connexion i
                    #print("T+ trouvé ",i," ",k)
                            drapeau_32[k][es][inp]=i
                    #if drapeau_plus[i]>=1:
                    #    comp[0][k].etat[2]=1

            for k in range(nb_composants[6]):   # afficheur double
                Tplusaff.append(-1)
                Tmoinsaff.append(-1)
                drapeau_aff.append([])    # ajout du composant k
                #for es in range(4):
                 #   drapeau_32[k].append([])  #  ajout des 4 portes
                for inp in range(7):
                    drapeau_aff[k].append(-1)  # ajout de 7 entrees à chaque afficheur
                if (comp[6][k].cx[7]==liste_fils[liste_connect[i][j]].liste[0].x and comp[6][k].cy[7]==liste_fils[liste_connect[i][j]].liste[0].y) \
                    or  (comp[6][k].cx[7]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[6][k].cy[7]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_plus_t[i]+=1   #  le plus du transistor est sur la connexion i
                    #print("T+ trouvé ",i," ",k)
                        Tplusaff[k]=i
                    #if drapeau_plus[i]>=1:
                    #    comp[0][k].etat[2]=1
                if (comp[6][k].cx[8]==liste_fils[liste_connect[i][j]].liste[0].x and comp[6][k].cy[8]==liste_fils[liste_connect[i][j]].liste[0].y) \
                    or  (comp[6][k].cx[8]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[6][k].cy[8]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_plus_t[i]+=1   #  le plus du transistor est sur la connexion i
                    #print("T+ trouvé ",i," ",k)
                        Tmoinsaff[k]=i

                #for es in range(4):
                for inp in range(7):
                        if (comp[6][k].cx[inp]==liste_fils[liste_connect[i][j]].liste[0].x and comp[6][k].cy[inp]==liste_fils[liste_connect[i][j]].liste[0].y) \
                        or  (comp[6][k].cx[inp]==liste_fils[liste_connect[i][j]].liste[-1].x and comp[6][k].cy[inp]==liste_fils[liste_connect[i][j]].liste[-1].y):
                    #drapeau_plus_t[i]+=1   #  le plus du transistor est sur la connexion i
                    #print("T+ trouvé ",i," ",k)
                            drapeau_aff[k][inp]=i
                    #if drapeau_plus[i]>=1:
                    #    comp[0][k].etat[2]=1

    #print("len(comp[5] = ",len(comp[5]))



 #   for k in range(len(comp[0])):
 #       for h in range(len(comp[0])):
    # analyse des connexions
    # 1 - Piles
    for k in range(len(comp[1])):
        if drapeau_plus[k]==drapeau_moins[k]:
            print("ERREUR : Court-circuit pile : ",k," connexion : ",drapeau_plus[k] )
            return
    for k in range(len(comp[0])):    # recherche d'un collecteur au +
        for h in range(len(comp[1])):
            if drapeau_coll[k]==drapeau_plus[h]:
                print("ERREUR : collecteur du transistor ",k," relié au plus de la pile ",h)
                return
    for k in range(len(comp[4])):
        for h in range(len(comp[4])):
            for es1 in range(4):
                for es2 in range(4):
                    if drapeau_00[k][es1][2]==drapeau_00[h][es2][2] and (h != k or es1 != es2) and drapeau_00[k][es1][2] != -1:
                        print("ERREUR : sortie ",es1," du 74LS00 ",k," reliée à la sortie ",es2," du 74LS00 ",h)
                        return
        for h in range(len(comp[5])):
            for es1 in range(4):
                for es2 in range(4):
                    if drapeau_00[k][es1][2]==drapeau_32[h][es2][2] and drapeau_00[k][es1][2] != -1:
                        print("ERREUR : sortie ",es1," du 74LS00 ",k," reliée à la sortie ",es2," du 74LS32 ",h)
                        return
    for k in range(len(comp[5])):
        for h in range(len(comp[5])):
            for es1 in range(4):
                for es2 in range(4):
                    if drapeau_32[k][es1][2]==drapeau_32[h][es2][2] and (h != k or es1 != es2) and drapeau_32[k][es1][2] != -1 :
                        print("ERREUR : sortie ",es1," du 74LS32 ",k," reliée à la sortie ",es2," du 74LS32 ",h," connexion = ",drapeau_32[k][es1][2], " = ",drapeau_32[h][es2][2])
                        return
    for k in range(len(comp[0])):
        for h in range(len(comp[4])):
            for es1 in range(4):
                #for es2 in range(4):
                    if drapeau_00[h][es1][2]==drapeau_coll[k] and drapeau_00[h][es1][2] != -1:
                        print("ERREUR : sortie ",es1," du 74LS00 ",k," reliée au collecteur du transistor ",k)
                        return
    for k in range(len(comp[0])):
        for h in range(len(comp[5])):
            for es1 in range(4):
                #for es2 in range(4):
                    if drapeau_32[h][es1][2]==drapeau_coll[k] and drapeau_32[h][es1][2] != -1:
                        print("ERREUR : sortie ",es1," du 74LS32 ",k," reliée au collecteur du transistor ",k)
                        return
    for k in range(len(comp[1])):
        for h in range(len(comp[4])):
            for es1 in range(4):
                #for es2 in range(4):
                    if drapeau_00[h][es1][2]==drapeau_plus[k] and drapeau_00[h][es1][2] != -1:
                        print("ERREUR : sortie ",es1," du 74LS00 ",k," reliée au + de la pile ",k)
                        return
    for k in range(len(comp[1])):
        for h in range(len(comp[4])):
            for es1 in range(4):
                #for es2 in range(4):
                    if drapeau_00[h][es1][2]==drapeau_moins[k] and drapeau_00[h][es1][2] != -1:
                        print("ERREUR : sortie ",es1," du 74LS00 ",k," reliée au - de la pile ",k)
                        return
    for k in range(len(comp[1])):
        for h in range(len(comp[5])):
            for es1 in range(4):
                #for es2 in range(4):
                    if drapeau_32[h][es1][2]==drapeau_plus[k] and drapeau_32[h][es1][2] != -1:
                        print("ERREUR : sortie ",es1," du 74LS32 ",k," reliée au + de la pile ",k)
                        return
    for k in range(len(comp[1])):
        for h in range(len(comp[5])):
            for es1 in range(4):
                #for es2 in range(4):
                    if drapeau_32[h][es1][2]==drapeau_moins[k] and drapeau_32[h][es1][2] != -1:
                        print("ERREUR : sortie ",es1," du 74LS32 ",k," reliée au - de la pile ",k)
                        return

    # 2 - Transistors
    for k in range(len(comp[0])):
        for h in range(len(comp[1])):
            for t in range(len(comp[1])):
                if Tplus[k]==drapeau_plus[h] and \
                Tmoins[k]==drapeau_moins[h] and \
                drapeau_basej[k]==drapeau_plus[t] and \
                Tmoins[k]==drapeau_moins[t] and \
                drapeau_baseb[k]==-1 :
                    #print("pass 1")
                    comp[0][k].etat[3]=0            # passant
                    can1.delete(comp[0][k].cmp_des)
                    comp[0][k].img=imgb[comp[0][k].type]
                    comp[0][k].cmp_des=can1.create_image(comp[0][k].x*paspixel,comp[0][k].y*paspixel,image=comp[0][k].img)
                elif Tplus[k]==drapeau_plus[h] and \
                Tmoins[k]==drapeau_moins[h] and \
                drapeau_basej[k]==drapeau_moins[t] and \
                Tmoins[k]==drapeau_moins[t] and \
                drapeau_baseb[k]==-1 :
                    comp[0][k].etat[3]=1            # bloqué
                    can1.delete(comp[0][k].cmp_des)
                    comp[0][k].img=imga[comp[0][k].type]
                    comp[0][k].cmp_des=can1.create_image(comp[0][k].x*paspixel,comp[0][k].y*paspixel,image=comp[0][k].img)


    for k in range(len(comp[0])):   # recherche d'une sortie de circuit intégré 74LS00
        for h in range(len(comp[1])):
            for t in range(len(comp[4])):
                for es in range(4):
                    if Tplus[k]==drapeau_plus[h] and \
                    Tmoins[k]==drapeau_moins[h] and \
                    drapeau_basej[k]==drapeau_00[t][es][2] and \
                    drapeau_baseb[k]==-1 and\
                    drapeau_00[t][es][2] != -1 :
                        if comp[4][t].etat[es]==1:
                            comp[0][k].etat[3]=0            # passant
                            can1.delete(comp[0][k].cmp_des)
                            comp[0][k].img=imgb[comp[0][k].type]
                            comp[0][k].cmp_des=can1.create_image(comp[0][k].x*paspixel,comp[0][k].y*paspixel,image=comp[0][k].img)
                        elif comp[4][t].etat[es]==0:
                            comp[0][k].etat[3]=1            # bloqué
                            can1.delete(comp[0][k].cmp_des)
                            comp[0][k].img=imga[comp[0][k].type]
                            comp[0][k].cmp_des=can1.create_image(comp[0][k].x*paspixel,comp[0][k].y*paspixel,image=comp[0][k].img)



    for k in range(len(comp[0])):   # recherche d'une sortie de circuit intégré 74LS32
        for h in range(len(comp[1])):
            for t in range(len(comp[5])):
                for es in range(4):
                    if Tplus[k]==drapeau_plus[h] and \
                    Tmoins[k]==drapeau_moins[h] and \
                    drapeau_basej[k]==drapeau_32[t][es][2] and \
                    drapeau_baseb[k]==-1 and\
                    drapeau_32[t][es][2] != -1 :
                        if comp[5][t].etat[es]==1:
                            comp[0][k].etat[3]=0            # passant
                            can1.delete(comp[0][k].cmp_des)
                            comp[0][k].img=imgb[comp[0][k].type]
                            comp[0][k].cmp_des=can1.create_image(comp[0][k].x*paspixel,comp[0][k].y*paspixel,image=comp[0][k].img)
                        elif comp[5][t].etat[es]==0:
                            comp[0][k].etat[3]=1            # bloqué
                            can1.delete(comp[0][k].cmp_des)
                            comp[0][k].img=imga[comp[0][k].type]
                            comp[0][k].cmp_des=can1.create_image(comp[0][k].x*paspixel,comp[0][k].y*paspixel,image=comp[0][k].img)
    # tous les transistors ont été parcouru et leur état connu

                # base k reliée au collecteur t
    for i in range(len(liste_connect)):  # boucle sur les connexions
        coll[i]=1
    for k in range(len(comp[0])):
        #print("debut coll")
        if drapeau_coll[k]!=-1:   # collecteur branché
            #print("coll : drapeau_coll[",t,"] = ",drapeau_coll[t])
            if comp[0][k].etat[3]==0:
                coll[drapeau_coll[k]]=0


    for k in range(len(comp[0])):
        for t in range(len(comp[0])):
            for h in range(len(comp[1])):
                if Tplus[k]==drapeau_plus[h] and \
                       Tmoins[k]==drapeau_moins[h] and \
                       drapeau_basej[k]==drapeau_coll[t] and \
                       drapeau_coll[t]!=-1 and \
                       drapeau_baseb[k]==-1 :
                        if coll[drapeau_coll[t]]==0:
                            #print("base du trans ",k," reliée au collecteur de ",t," à zéro")
                            comp[0][k].etat[3]=1
                            can1.delete(comp[0][k].cmp_des)
                            comp[0][k].img=imga[comp[0][k].type]
                            comp[0][k].cmp_des=can1.create_image(comp[0][k].x*paspixel,comp[0][k].y*paspixel,image=comp[0][k].img)
                        elif coll[drapeau_coll[t]]==1:
                            #print("base du trans ",k," reliée au collecteur de ",t," à un")
                            comp[0][k].etat[3]=0
                            can1.delete(comp[0][k].cmp_des)
                            comp[0][k].img=imgb[comp[0][k].type]
                            comp[0][k].cmp_des=can1.create_image(comp[0][k].x*paspixel,comp[0][k].y*paspixel,image=comp[0][k].img)

# transistor avec baseb


    # analyse condensateur au plus ou moins
    drap_cond1=[]
    drap_cond2=[]
    for k in range(len(comp[3])):
        drap_cond1.append(0)
        drap_cond2.append(0)
        for t in range(len(comp[0])):
            # on cherche la borne cx0 ou cx1 du condensateur relié à la base d'un transistor
            if drapeau_cond_0[k]==drapeau_baseb[t] and drapeau_cond_0[k] != -1:
                #print("1-condens = ",k," transistor = ",t," drapeau_cond_0[k] = ",drapeau_cond_0[k])
                for h in range(len(comp[1])):
                    if Tplus[t]==drapeau_plus[h] and \
                    Tmoins[t]==drapeau_moins[h]:               # transistor bien alimenté
                        if drapeau_basej[t]==drapeau_plus[h]:
                            if drapeau_cond_1[k]==drapeau_moins[h]:
                                                                                          # pas de temporisation en cours
                                if comp[3][k].etat[0]==1 :
                                    #print("1 condensateur préchargé")
                                    #print("1 déclenchement de la temporisation")
                                    # déclenchement de la temporisation
                                    comp[3][k].etat[0]=0   # on devra à nouveau précharger le condensateur k
                                    comp[0][t].etat[3]=1   # transistor t bloqué
                                    can1.delete(comp[0][t].cmp_des)
                                    comp[0][t].img=imga[0]
                                    comp[0][t].cmp_des=can1.create_image(comp[0][t].x*paspixel,comp[0][t].y*paspixel,image=comp[0][t].img)
                                    comp[3][k].etat[1]=0      # chgt etat condens pour bloquer t : debut de la décharge lente
                                    fen1.after(tau,apres_tempo,k,t)
                                    # le transistor t est rallumé
                            elif drapeau_cond_1[k]==drapeau_plus[h]:
                                #if comp[3][k].etat[0]==0:           # condensateur non préchargé
                                    #print("1 condensateur non préchargé")
                                #if drapeau_cond_1[k]==drapeau_plus[h]:
                                    #tm.clear()

                                    drap_cond1[k]=1   # pour la tempo
                                    comp[3][k].etat[0]=1        #le condensateur est maintenant préchargé
                                    #print("1 le condensateur est maintenant préchargé")
                                    comp[0][t].etat[3]=0   # transistor t passant
                                    can1.delete(comp[0][t].cmp_des)
                                    comp[0][t].img=imgb[0]
                                    comp[0][t].cmp_des=can1.create_image(comp[0][t].x*paspixel,comp[0][t].y*paspixel,image=comp[0][t].img)


            if drapeau_cond_1[k]==drapeau_baseb[t] and drapeau_cond_1[k] != -1:
                #xc[k]=1
                #print("2-condens = ",k," transistor = ",t)
                for h in range(len(comp[1])):
                    if Tplus[t]==drapeau_plus[h] and \
                    Tmoins[t]==drapeau_moins[h]:               # transistor bien alimenté
                        if drapeau_basej[t]==drapeau_plus[h]:
                            #drap_cond=0
                                                                                          # pas de temporisation en cours
                            if drapeau_cond_0[k]==drapeau_moins[h]:
                                if comp[3][k].etat[0]==1 :     # and comp[3][k].etat[1]==1 :           # condensateur préchargé et
                                    #print("2 condensateur préchargé")
                                    # déclenchement de la temporisation
                                    #print("2 déclenchement de la temporisation")
                                    comp[3][k].etat[0]=0   # on devra à nouveau précharger le condensateur k
                                    comp[0][t].etat[3]=1   # transistor t bloqué
                                    can1.delete(comp[0][t].cmp_des)
                                    comp[0][t].img=imga[0]
                                    comp[0][t].cmp_des=can1.create_image(comp[0][t].x*paspixel,comp[0][t].y*paspixel,image=comp[0][t].img)
                                    comp[3][k].etat[1]=0      # chgt etat condens pour bloquer t : debut de la décharge lente
                                    fen1.after(tau,apres_tempo,k,t)
                                    # le transistor t est rallumé
                            elif drapeau_cond_0[k]==drapeau_plus[h]:
                                if comp[3][k].etat[0]==0:           # condensateur non préchargé
                                    #print("2 condensateur non préchargé")

                                    comp[3][k].etat[0]=1        #le condensateur est maintenant préchargé
                                    drap_cond1[k]=1   # pour la tempo
                                    #print("2 le condensateur est maintenant préchargé")
                                    comp[0][t].etat[3]=0   # transistor t passant
                                    can1.delete(comp[0][t].cmp_des)
                                    comp[0][t].img=imgb[0]
                                    comp[0][t].cmp_des=can1.create_image(comp[0][t].x*paspixel,comp[0][t].y*paspixel,image=comp[0][t].img)


    # analyse condensateur au collecteur d'un transitor u
    #for u in range(len(comp[0])):
    #    if comp[0][u].etat[3]==0
    #drap_cond2=[]
    for k in range(len(comp[3])):
        drap_cond2.append(0)
        drap_cond1.append(0)
        for t in range(len(comp[0])):
            #xc.append(-1)
            # on cherche la borne cx0 ou cx1 du condensateur relié à la base d'un transistor
            if drapeau_cond_0[k]==drapeau_baseb[t] and drapeau_cond_0[k] != -1:
                #print("3-condens = ",k," transistor = ",t," drapeau_cond_0[k] = ",drapeau_cond_0[k])
                #xc[k]=0    # la borne du condensateur reliée à la base de t est cx[0]
                for h in range(len(comp[1])):
                    if Tplus[t]==drapeau_plus[h] and \
                    Tmoins[t]==drapeau_moins[h]:               # transistor bien alimenté
                        for u in range(len(comp[0])):
                            if drapeau_basej[t]==drapeau_plus[h]:
                                 #drap_cond=0
                                #print("transist u = ",u," drapeau_cond_1[k]=",drapeau_cond_1[k]," drapeau_coll[u] = ",drapeau_coll[u]," coll[drapeau_coll[u]] = ",coll[drapeau_coll[u]])
                                if drapeau_cond_1[k]==drapeau_coll[u]  and coll[drapeau_coll[u]]==0:

                            #if comp[3][k].etat[0]==1 : # and comp[3][k].etat[1]==1 :           # condensateur préchargé et
                                                                                          # pas de temporisation en cours
                                    #print("trans u OK  = ",u," drapeau_cond_1[k]=",drapeau_cond_1[k]," drapeau_coll[u] = ",drapeau_coll[u])
                                    #print("A cond ",k," etat[0] = ",comp[3][k].etat[0]," etat[1] = ",comp[3][k].etat[1])
                                    if comp[3][k].etat[0]==1 :
                                        #print("3 condensateur préchargé")
                                #if drapeau_cond_1[k]==drapeau_moins[h]:
                                        #print("3 déclenchement de la temporisation")
                                    # déclenchement de la temporisation
                                        comp[3][k].etat[0]=0   # on devra à nouveau précharger le condensateur k
                                        comp[0][t].etat[3]=1   # transistor t bloqué
                                        can1.delete(comp[0][t].cmp_des)
                                        comp[0][t].img=imga[0]
                                        comp[0][t].cmp_des=can1.create_image(comp[0][t].x*paspixel,comp[0][t].y*paspixel,image=comp[0][t].img)
                                        comp[3][k].etat[1]=0      # chgt etat condens pour bloquer t : debut de la décharge lente
                                        coll[drapeau_coll[t]]=1
                                        #print("B cond ",k," etat[0] = ",comp[3][k].etat[0]," etat[1] = ",comp[3][k].etat[1])
                                        fen1.after(tau,apres_tempo,k,t)
                                    # le transistor t est rallumé
                                elif drapeau_cond_1[k]==drapeau_coll[u] and coll[drapeau_coll[u]]!=0 :
                                #if comp[3][k].etat[0]==0:           # condensateur non préchargé
                                    #print("3 condensateur non préchargé")
                                #if drapeau_cond_1[k]==drapeau_plus[h]:
                                    #tm.clear()

                                    drap_cond2[k]=1   # pour la tempo
                                    comp[3][k].etat[0]=1        #le condensateur est maintenant préchargé
                                    #print("3 le condensateur est maintenant préchargé")
                                    #print("E cond ",k," etat[0] = ",comp[3][k].etat[0]," etat[1] = ",comp[3][k].etat[1])
                                    comp[0][t].etat[3]=0   # transistor t passant
                                    can1.delete(comp[0][t].cmp_des)
                                    comp[0][t].img=imgb[0]
                                    comp[0][t].cmp_des=can1.create_image(comp[0][t].x*paspixel,comp[0][t].y*paspixel,image=comp[0][t].img)


            if drapeau_cond_1[k]==drapeau_baseb[t] and drapeau_cond_1[k] != -1:
                #xc[k]=1
                #print("4-condens = ",k," sur base de transistor = ",t)
                for h in range(len(comp[1])):
                    if Tplus[t]==drapeau_plus[h] and \
                    Tmoins[t]==drapeau_moins[h]:               # transistor bien alimenté
                        for u in range(len(comp[0])):
                            if drapeau_basej[t]==drapeau_plus[h]:
                                #print("u = ",u," drapeau_cond_0[k= ",k," ]=",drapeau_cond_0[k]," drapeau_coll[u] = ",drapeau_coll[u]," coll[drapeau_coll[u]] = ",coll[drapeau_coll[u]])

                                #drap_cond=0
                                if drapeau_cond_0[k]==drapeau_coll[u]  and coll[drapeau_coll[u]]==0:
                                    #print("u OK (4) = ",u," drapeau_cond_0[k = ",k," ]=",drapeau_cond_0[k]," drapeau_coll[u] = ",drapeau_coll[u])
                                    #print("C cond ",k," etat[0] = ",comp[3][k].etat[0]," etat[1] = ",comp[3][k].etat[1])
                                    if comp[3][k].etat[0]==1 :     # and comp[3][k].etat[1]==1 :           # condensateur préchargé et
                                                                                          # pas de temporisation en cours
                                        #print("4 condensateur ",k," préchargé")

                                    # déclenchement de la temporisation
                                        #print("4 déclenchement de la temporisation")
                                        comp[3][k].etat[0]=0   # on devra à nouveau précharger le condensateur k
                                        comp[0][t].etat[3]=1   # transistor t bloqué
                                        can1.delete(comp[0][t].cmp_des)
                                        comp[0][t].img=imga[0]
                                        comp[0][t].cmp_des=can1.create_image(comp[0][t].x*paspixel,comp[0][t].y*paspixel,image=comp[0][t].img)
                                        comp[3][k].etat[1]=0      # chgt etat condens pour bloquer t : debut de la décharge lente
                                        coll[drapeau_coll[t]]=1
                                        #print("D cond ",k," etat[0] = ",comp[3][k].etat[0]," etat[1] = ",comp[3][k].etat[1])
                                        fen1.after(tau,apres_tempo,k,t)
                                    # le transistor t est rallumé
                                elif drapeau_cond_0[k]==drapeau_coll[u] and coll[drapeau_coll[u]]!=0 :
                                    if comp[3][k].etat[0]==0:           # condensateur non préchargé
                                        #print("4 condensateur ",k,"  non préchargé")
                                        comp[3][k].etat[0]=1        #le condensateur est maintenant préchargé
                                        #print("F cond ",k," etat[0] = ",comp[3][k].etat[0]," etat[1] = ",comp[3][k].etat[1])
                                        drap_cond2[k]=1   # pour la tempo
                                        #print("4 le condensateur ",k," est maintenant préchargé")
                                        comp[0][t].etat[3]=0   # transistor t passant
                                        can1.delete(comp[0][t].cmp_des)
                                        comp[0][t].img=imgb[0]
                                        comp[0][t].cmp_des=can1.create_image(comp[0][t].x*paspixel,comp[0][t].y*paspixel,image=comp[0][t].img)


    for k in range(len(comp[4])) :   # 74LS00
        for h in range(len(comp[1])):
            if Tplus00[k]==drapeau_plus[h] and \
                    Tmoins00[k]==drapeau_moins[h]:               # 74LS00  bien alimenté
                        for es1 in range(4):
                            test=0   # etat de la sortie es1 par defaut
                            for inp1 in range(2):
                                #print("passage 1 dans 74LS00")
                                for t in range(len(comp[4])):   # recherche d'une sortie d'un 74LS00
                                    for es2 in range(4):
                                        if drapeau_00[k][es1][inp1]==drapeau_00[t][es2][2]  and \
                                        drapeau_00[k][es1][inp1] != -1 :
                                            if comp[4][t].etat[es2]==0:
                                                test=1
                                for t in range(len(comp[5])):   # recherche d'une sortie d'un 74LS32
                                    for es2 in range(4):
                                        if drapeau_00[k][es1][inp1]==drapeau_32[t][es2][2]  and \
                                        drapeau_00[k][es1][inp1] != -1 :
                                            if comp[5][t].etat[es2]==0:
                                                test=1
                                for l in range (len(comp[1])):
                                    #print("passage 2 dans 74LS00")
                                    if drapeau_00[k][es1][inp1]==drapeau_moins[l]:
                                        #print("passage 3 dans 74LS00")
                                        test=1
                                for t in range(len(comp[0])):
                                    # recherche du collecteur d'un transistor à 0
                                    if drapeau_00[k][es1][inp1]==drapeau_coll[t]  and \
                                    drapeau_00[k][es1][inp1] != -1:
                                        if coll[drapeau_coll[t]]==0:
                                            test=1

                            if test==1:
                                comp[4][k].etat[es1]=1
                                #print("passage okok dans 74LS00")
                            else:
                                comp[4][k].etat[es1]=0
                                #print("passage okok dans 74LS00 : 000000000000000000")




            else :
                print("74LS00 ",k," pas alimenté")




    for k in range(len(comp[5])) :   # 74LS32
        for h in range(len(comp[1])):
            if Tplus32[k]==drapeau_plus[h] and \
                    Tmoins32[k]==drapeau_moins[h]:               # 74LS32  bien alimenté
                        for es1 in range(4):
                            test=0   # etat de la sortie es1 par defaut
                            for inp1 in range(2):
                                #print("passage 1 dans 74LS32")
                                if drapeau_32[k][es1][inp1]==-1 :  # non branché == 1 en sortie
                                    test=1
                                for t in range(len(comp[4])):   # recherche d'une sortie d'un 74LS00
                                    for es2 in range(4):
                                        if drapeau_32[k][es1][inp1]==drapeau_00[t][es2][2]  and \
                                        drapeau_32[k][es1][inp1] != -1 :
                                            if comp[4][t].etat[es2]==1:
                                                test=1
                                for t in range(len(comp[5])):   # recherche d'une sortie d'un 74LS32
                                    for es2 in range(4):
                                        if drapeau_32[k][es1][inp1]==drapeau_32[t][es2][2]  and \
                                        drapeau_32[k][es1][inp1] != -1 :
                                            if comp[5][t].etat[es2]==1:
                                                test=1

                                for l in range (len(comp[1])):
                                    #print("passage 2 dans 74LS32")
                                    if drapeau_32[k][es1][inp1]==drapeau_plus[l]:
                                        #print("passage 3 dans 74LS32")
                                        test=1
                                for t in range(len(comp[0])):
                                    # recherche du collecteur d'un transistor à 0
                                    if drapeau_32[k][es1][inp1]==drapeau_coll[t]  and \
                                    drapeau_32[k][es1][inp1] != -1:
                                        if coll[drapeau_coll[t]]==1:
                                            test=1

                            if test==1:
                                comp[5][k].etat[es1]=1
                                #print("passage okok dans 74LS32")
                            else:
                                comp[5][k].etat[es1]=0
                                #print("passage okok dans 74LS32 : 000000000000000000")




            else :
                print("74LS32 ",k," pas alimenté")

    for k in range(len(comp[6])) :   # afficheur double
        for h in range(len(comp[1])):
            if Tplusaff[k]==drapeau_plus[h] and \
                    Tmoinsaff[k]==drapeau_moins[h]:               # 74LS32  bien alimenté
                        #for es1 in range(4):
                        #    test=0   # etat de la sortie es1 par defaut
                            resu=0
                            for inp1 in range(7):
                                #print("passage 1 dans afficheur")
                                if drapeau_aff[k][inp1]==-1 :  # non branché == 1 en sortie
                                    print("Afficheur ",k," mal connecté : ",inp1)
                                else :
                                    for l in range(len(comp[1])):
                                        if drapeau_aff[k][inp1]==drapeau_plus[l]:  # recherche de mise au plus ou au moins
                                            resu=resu+2**inp1
                                            #print("passage pile dans afficheur resu = ",resu)

                                    for l in range(len(comp[0])):   # recherche du collecteur d'un transistor
                                        if drapeau_coll[l] != -1:
                                            if drapeau_aff[k][inp1]==drapeau_coll[l]:
                                                if coll[drapeau_coll[l]]==1:
                                                    resu=resu+2**inp1
                                                    #print("passage collecteur dans afficheur  resu = ",resu)
                                    for l in range(len(comp[4])):   # recherche d'une sortie de 74LS00
                                        for es2 in range(4):
                                            if drapeau_aff[k][inp1]==drapeau_00[l][es2][2]:
                                                if comp[4][l].etat[es2]==1:
                                                    resu=resu+2**inp1
                                                    #print("passage 74LS00 dans afficheur resu = ",resu)

                                    for l in range(len(comp[5])):   # recherche d'une sortie de 74LS32
                                        for es2 in range(4):
                                            if drapeau_aff[k][inp1]==drapeau_32[l][es2][2]:
                                                if comp[5][l].etat[es2]==1:
                                                    resu=resu+2**inp1
                                                    #print("passage 74LS32 dans afficheur  resu = ",resu)

                            #print("resu afficheur ",k," = ",resu)
                            if resu >99:
                                can1.delete(comp[6][k].cmp_des1)
                                can1.delete(comp[6][k].cmp_des2)
                                comp[6][k].cmp_des1=can1.create_image((comp[6][k].x-4)*paspixel,comp[6][k].y*paspixel,image=affg[11])
                                comp[6][k].cmp_des1=can1.create_image((comp[6][k].x+4)*paspixel,comp[6][k].y*paspixel,image=affd[11])
                            else:
                                if resu <10:
                                    can1.delete(comp[6][k].cmp_des1)
                                    can1.delete(comp[6][k].cmp_des2)
                                    comp[6][k].cmp_des1=can1.create_image((comp[6][k].x-4)*paspixel,comp[6][k].y*paspixel,image=affg[10])
                                    comp[6][k].cmp_des1=can1.create_image((comp[6][k].x+4)*paspixel,comp[6][k].y*paspixel,image=affd[resu])
                                else:
                                    dix=resu//10
                                    une=resu%10
                                    can1.delete(comp[6][k].cmp_des1)
                                    can1.delete(comp[6][k].cmp_des2)
                                    comp[6][k].cmp_des1=can1.create_image((comp[6][k].x-4)*paspixel,comp[6][k].y*paspixel,image=affg[dix])
                                    comp[6][k].cmp_des1=can1.create_image((comp[6][k].x+4)*paspixel,comp[6][k].y*paspixel,image=affd[une])
            else:
                print("afficheur ",k," mal alimenté")
                can1.delete(comp[6][k].cmp_des1)
                can1.delete(comp[6][k].cmp_des2)
                comp[6][k].cmp_des1=can1.create_image((comp[6][k].x-4)*paspixel,comp[6][k].y*paspixel,image=affg[10])
                comp[6][k].cmp_des1=can1.create_image((comp[6][k].x+4)*paspixel,comp[6][k].y*paspixel,image=affd[10])

    # traitement des voltmetres
    # affectation d'un niveauélectrique à une connexion
    volt=[]
    for i in range(len(liste_connect)):
        volt.append(-1)     # pas connecté a priori
    # niveau imposé par un générateur :
    for k in range(len(comp[1])):
        if drapeau_plus[k]!=-1:
            volt[drapeau_plus[k]]=1
        if drapeau_moins[k]!=-1:
            volt[drapeau_moins[k]]=0

    # niveau imposé par un collecteur
    for k in range(len(comp[0])):
        #if volt[drapeau_coll[k]]=-1:
         #   volt[drapeau_coll[k]]=1
         #   if drapeau_coll[k]==0:
         #       volt[drapeau_coll[k]]=0
         volt[drapeau_coll[k]]=coll[drapeau_coll[k]]

    # niveau imposé par un 74LS00
    for k in range(len(comp[4])):
        for es in range(4):
            if drapeau_00[k][es][2]!=-1:
                volt[drapeau_00[k][es][2]]=comp[4][k].etat[es]

    # niveau imposé par un 74LS32
    for k in range(len(comp[5])):
        for es in range(4):
            if drapeau_32[k][es][2]!=-1:
                volt[drapeau_32[k][es][2]]=comp[5][k].etat[es]
    #for i in range(len(liste_connect)):
    #    print("volt[",i,"] = ",volt[i])

    # recherche de la connexion d'un voltmetre sur le fil j
    for h in range(len(liste_volt)):
        liste_volt[h].coul="aqua"
        px=liste_volt[h].x
        py=liste_volt[h].y
        itrouve=-1
        for i in range(len(liste_connect)):
            for j in range(len(liste_connect[i])):
                for k in range(len(liste_fils[liste_connect[i][j]].liste)-1):
                    p1j=liste_fils[liste_connect[i][j]].liste[k]
                    p2j=liste_fils[liste_connect[i][j]].liste[k+1]
                    if (((px-p1j.x)*(px-p2j.x)<0 and py==p1j.y and py==p2j.y)or \
                       ((py-p1j.y)*(py-p2j.y)<0 and px==p1j.x and px==p2j.x)) and itrouve==-1:
                        # le voltmetre est sur le fil j et pas à une extremite
                        itrouve=1
                        #v=Voltmetre(px,py,j,coul="aqua")
                        #v.trace()
                        #liste_volt.append(v)
                        #cal_con2()

                #if liste_connect[i][j]==liste_volt[h].fil:
                        if volt[i]==1:
                            liste_volt[h].coul="red"
                        if volt[i]==0:
                            liste_volt[h].coul="green"
                        #print("liste_volt[",h,"] = ",liste_volt[h].coul)
                        liste_volt[h].change_coul()




    for i in range(len(liste_fils)):
        for j in range(len(liste_fils[i].liste_lignes)):
            can1.tag_raise(liste_fils[i].liste_lignes[j])
        can1.tag_raise(liste_fils[i].liste[0].cercle)
        can1.tag_raise(liste_fils[i].liste[-1].cercle)


def apres_tempo(k,t):
    global drap_cond1, drap_cond2, appel_tempo
    appel_tempo+=1
    #print("debut tempo appel tempo = ",appel_tempo," tttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt")
    #comp[3][k].etat[0]=0   # on devra à nouveau précharger le condensateur k
    comp[0][t].etat[3]=0  # le transistor t est à nouveau passant
    can1.delete(comp[0][t].cmp_des)
    comp[0][t].img=imgb[0]
    comp[0][t].cmp_des=can1.create_image(comp[0][t].x*paspixel,comp[0][t].y*paspixel,image=comp[0][t].img)
    if drap_cond1[k]==0 and drap_cond2[k]==0:   # on n'a remis la baseb au plus
        comp[3][k].etat[0]=0      # on attend de repasser au plus le cx[1]
    #print("G cond ",k," etat[0] = ",comp[3][k].etat[0]," etat[1] = ",comp[3][k].etat[1])

    for i in range(len(liste_fils)):
        for j in range(len(liste_fils[i].liste_lignes)):
            can1.tag_raise(liste_fils[i].liste_lignes[j])
        can1.tag_raise(liste_fils[i].liste[0].cercle)
        can1.tag_raise(liste_fils[i].liste[-1].cercle)
    #print("fin tempo")
    comp[3][k].etat[1]=1      # on ne bloque plus la base
    #print("H cond ",k," etat[0] = ",comp[3][k].etat[0]," etat[1] = ",comp[3][k].etat[1])
    #print("fin tempo")
    cal_con()
    cal_con()







def calc_circ():
    for k in range(len(comp[0])):
        comp[0][k].changt_etat()
        #print("trans ",k," Etat[0] = ",comp[0][k].etat[0])
    for i in range(len(liste_fils)):
        for j in range(len(liste_fils[i].liste_lignes)):
            can1.tag_raise(liste_fils[i].liste_lignes[j])
        can1.tag_raise(liste_fils[i].liste[0].cercle)
        can1.tag_raise(liste_fils[i].liste[-1].cercle)


def clean():
    global liste_fils
    nb_fils_courts=0
    for i in range(len(liste_fils)):
        if len(liste_fils[i].liste)<2:
            nb_fils_courts+=1
    print("CLEAN : ",nb_fils_courts," fils courts à supprimer")
    for ii in range(nb_fils_courts):
        ifilselect=-1
        trouve=False
        for i in range(len(liste_fils)):
            if len(liste_fils[i].liste)<2:
                ifilselect=i
                            #print(" fil trouve i=",i)
                trouve=True
                break
        if trouve :
            print("CLEAN : ifilselect = ",ifilselect)
            f1=liste_fils[ifilselect]
            f1.suppr()
            del(liste_fils[ifilselect])
            ifilselect=-1


def e_f():
    global larg,ident, pas_change, nbfic, commentaire
    if larg:
        ident=entree4.get()
        if 'Identifiant définitif demandé'==ident or len(ident)<2:
            print("Donner l'identifiant définitif")
            return
        larg=False
    else:
        entree4.delete(0,END)
        entree4.insert(0,ident)
    if pas_change:
        print("Le fichier n'a pas été modifié avant sauvegarde")
        return
    pas_change=True   #      on ne sauvegarde un fichier que s'il a été modifié
    nbfic=nbfic+1                   # c'est toujours le dernier +1 pour ne pas risquer d'écraser un autre fichier
    entree3.delete(0,END)
    entree3.insert(0,str(nbfic))
    cf=open('configtrans.txt','w')
    cf.write(str(nbfic)+'\nNumero du dernier fichier trans créé')
    cf.close()
    fw=open('trans'+str(nbfic)+'.txt','w')
    fw.write('Ceci est le contenu du fichier trans'+str(nbfic)+'.txt\n')
    fw.write('Identifiant définitif :\n'+ident+'\n')
    fw.write('Ce fichier contient les composants et les fils :\n')
    calcul=''
    for ich in range (len(ident)):
        calcul=calcul+str(ord(ident[ich]))+';'
    fw.write(calcul)
    fw.write('\n')
    fw.write(str(nb_types_cmp))
    fw.write('\n')
    for i in range(nb_types_cmp):  # ecriture des composants
        fw.write(str(len(comp[i])))
        fw.write('\n')
        for j in range(len(comp[i])):
            fw.write(str(comp[i][j].x)+';')
        fw.write('\n')
        for j in range(len(comp[i])):
            fw.write(str(comp[i][j].y)+';')
        fw.write('\n')
    for j in range(len(comp[2])):
        fw.write(str(comp[2][j].etat2)+';')
    fw.write('\n')
    clean()         #    appel fonction qui supprime les fils de longueur inférieure à 2
    fw.write(str(len(liste_fils)))
    fw.write('\n')
    for i in range(len(liste_fils)):
        for j in range(len(liste_fils[i].liste)):
            fw.write(str(liste_fils[i].liste[j].x)+';')
        fw.write('\n')
    #for i in range(len(liste_fils)):
        for j in range(len(liste_fils[i].liste)):
            fw.write(str(liste_fils[i].liste[j].y)+';')
        fw.write('\n')
    commentaire=entree5.get()
    fw.write(commentaire)
    print("Sauvegarde effectuée")
    fw.close()

def o_f():
    global larg,ident, pas_change,comp, liste_fils,commentaire
    test=0
    for i in range(nb_types_cmp):
        if len(comp[i])>0:
            test+=1
    if test>0 or len(liste_fils)>0:
        print("La page doit être vide pour l'ouverture d'un fichier : ",test,' ',len(liste_fils))
        return # on ne charge un fichier que sur une page vide
    nbfic2=int(entree3.get())
    print("Fichier en lecture : ",nbfic2)
    if nbfic2!=0:
        fr=open('trans'+str(nbfic2)+'.txt','r')
        lire=fr.readline()
        lire=fr.readline()
        lire=fr.readline()
        lire=fr.readline()
        lire=fr.readline()
        lire=lire[0:-1]
        lireli=lire.split(";")
        ide=''
        del lireli[-1]
        larg=False
        for a in lireli:
            ide=ide+chr(int(a))
        #print("id = ",ide)
        entree4.delete(0,END)
        entree4.insert(0,ide)
        ident=ide
        lire=fr.readline()  # nb types de composants
        #nb_compo_li=int(lire[0:-1])
        nb_compo_li=int(lire)
        #comp=[]
        #nb_composants=[]
        for i in range(nb_compo_li):
            #comp.append([])
            #nb_composants.append(0)
            lire=fr.readline()
            nbi=int(lire)
            lire=fr.readline()
            lire=lire[0:-1]
            ix=lire.split(";")
            lire=fr.readline()
            lire=lire[0:-1]
            iy=lire.split(";")
            for j in range(nbi):
                compo=Composant(i,int(ix[j]),int(iy[j]))
                comp[i].append(compo)
                pas_change=False
                nb_composants[i]+=1
                if i==0:
                    drapeau_base.append(0)
                #if i==2:
                    #print("compo 0 x = ",compo.cx[0],"compo 0 y = ",compo.cy[0],"compo 1 x = ",compo.cx[1],"compo 1 y = ",compo.cy[1],"compo 2 x = ",compo.cx[2],"compo 2 y = ",compo.cy[2],)
        lire=fr.readline()
        lire=lire[0:-1]
        iy=lire.split(";")
        del(iy[-1])
        #print("iy[] = ",iy)
        #print("comp[].etat2 = ",comp[2][0].etat2)
        for j in range(len(iy)):  # eta2 pour le commutateur
            #print("etat2 = ",iy[j])
            comp[2][j].chet(int(iy[j]))
            if int(iy[j])==1:
                comp[2][j].chet(0)
                comp[2][j].changt_etat()
                #print("2 comp[].etat2 = ",comp[2][0].etat2)

        # lecture des fils
        lire=fr.readline()  # nb de fils
        nb_fils_li=int(lire)
        for i in range(nb_fils_li):
            lire=fr.readline()
            lire=lire[0:-1]
            ix=lire.split(";")
            del ix[-1]
            lire=fr.readline()
            lire=lire[0:-1]
            iy=lire.split(";")
            del iy[-1]
            saut=False
            for h in range(len(comp[2])):  # test si c'est un fil sur le commutateur
                #print("commut h= ",h," ix[0] = ",ix[0]," iy[0] = ",iy[0],' ',comp[2][h].cx[0],' ',comp[2][h].cy[0],' ',comp[2][h].cx[1],' ',comp[2][h].cy[1])
                #print("commut h= ",h," ix[1] = ",ix[1]," iy[1] = ",iy[1],' ',comp[2][h].cx[1],' ',comp[2][h].cy[1],' ',comp[2][h].cx[2],' ',comp[2][h].cy[2])
                #print('len(ix) = ',len(ix))


                if len(ix)>1 and((int(ix[0])==comp[2][h].cx[0] and \
                int(iy[0])==comp[2][h].cy[0] and \
                int(ix[1])==comp[2][h].cx[1] and \
                int(iy[1])==comp[2][h].cy[1]) or \
                (int(ix[0])==comp[2][h].cx[1] and \
                int(iy[0])==comp[2][h].cy[1] and \
                int(ix[1])==comp[2][h].cx[2] and \
                int(iy[1])==comp[2][h].cy[2])) :

                    saut=True
                    #print("commut 2 h= ",h," ix[0] = ",ix[0],comp[2][h].cx[0],' ',comp[2][h].cy[0],' ',comp[2][h].cx[1],' ',comp[2][h].cy[1])
                    #print("commut 2 h= ",h," ix[1] = ",ix[1],comp[2][h].cx[1],' ',comp[2][h].cy[1],' ',comp[2][h].cx[2],' ',comp[2][h].cy[2])

            if not(saut):
                p1=Point(int(ix[0]),int(iy[0]),coul="goldenrod3")
                p1.trace()
                f1=Fil(p1,coul="goldenrod3")
                liste_fils.append(f1)
                liste_points.append(p1)
                pas_change=False
                for j in range(1,len(ix)):
                    p2=Point(int(ix[j]),int(iy[j]),coul="goldenrod3")
            #print("f1 = ",len(f1.liste))
                    pas_change=False
                    f1.efface()
                    f1.ajoute(p2)
                    f1.trace()

        commentaire=fr.readline()
        entree5.delete(0,END)
        entree5.insert(0,commentaire)
        clean()

    fr.close()
    print("fin lecture fichier")
def cal_con2():
    creer_connexions()
    #for i in range(len(comp[0])):
    for i in range(10):
        #creer_connexions()
        cal_con()



def fen1xplus():
    global fen1x
    fen1x+=80
    can1['width']=str(fen1x)

def fen1xmoins():
    global fen1x
    fen1x-=80
    can1['width']=str(fen1x)

def fen1yplus():
    global fen1y
    fen1y+=80
    can1['height']=str(fen1y)

def fen1ymoins():
    global fen1y
    fen1y-=80
    can1['height']=str(fen1y)




appel=0
appel_tempo=0
tau=2000   # tempo condensateur
nb_types_cmp=7    # transistor, pile, commutateur, condensateur, 74LS00, 74LS32, afficheur_double
nb_composants=[]
for i in range(nb_types_cmp):
    nb_composants.append([])
    nb_composants[i]=0
comp=[]
for i in range(nb_types_cmp):
    comp.append([])
liste_connect=[]
liste_fils=[]
liste_points=[]
liste_volt=[]
drapeau_plus=[]
drapeau_moins=[]
dra_con=[]
drapeau_base=[]   # note si la base du transistor est toujours connectée
larg=True
pas_change=True
dimx=8000        # 2400
dimy=8000        # 2400
fen1x=800   # 800
fen1y=800   #  800
paspixel=20
depla_x=0
depla_y=0
coul_maillage="turquoise"
ep_maillage=1
connexions=[]
derniere_connexion=0 # pas de connexion au début. Il y aura des trous dans la numerotation, ou
                     # des connexions vides
dernier_fil=[]   # 2 indices : 1 pour la connexion, 1 pour le fil . C'est un numéro.
dernier_fil.append(0)
ptdebcree=False
point_en_cours=None
numero_action=2
ifilselect=-1
ipointselect=-1
coul="red"
root=Tk()
root.geometry("+100+100")
fen1=Toplevel(root,width=fen1x+30, height=fen1y+30,bg="orange")
fen1.resizable(False, False)
fen1.geometry("+150+100")
imga=[]
imgb=[]
icompo=0
tension_on_1=False
#for i in range(3):
imga.append(PhotoImage(file="translab_photos/transistor_eteint_01.png"))
imgb.append(PhotoImage(file="translab_photos/transistor_allume_01.png"))
imga.append(PhotoImage(file="translab_photos/pile_06_ok.png"))
imgb.append(PhotoImage(file="translab_photos/pile_06_ok.png"))
imga.append(PhotoImage(file="translab_photos/inter_05_2_pos_droit.png"))
imgb.append(PhotoImage(file="translab_photos/inter_05_2_pos_gauche.png"))
imga.append(PhotoImage(file="translab_photos/condensateur_47mf_reduit_03.png"))
imgb.append(PhotoImage(file="translab_photos/condensateur_47mf_reduit_03.png"))
imga.append(PhotoImage(file="translab_photos/_7400_03.png"))
imgb.append(PhotoImage(file="translab_photos/_7400_03.png"))
imga.append(PhotoImage(file="translab_photos/_7432_05.png"))
imgb.append(PhotoImage(file="translab_photos/_7432_05.png"))
imga.append(PhotoImage(file="translab_photos/afficheur_03_0.png"))
imgb.append(PhotoImage(file="translab_photos/afficheur_03_0.png"))

nb=len(imga)
affg=[]
affd=[]
affg.append(PhotoImage(file="translab_photos/afficheur_04_0.png"))
affg.append(PhotoImage(file="translab_photos/afficheur_04_1.png"))
affg.append(PhotoImage(file="translab_photos/afficheur_04_2.png"))
affg.append(PhotoImage(file="translab_photos/afficheur_04_3.png"))
affg.append(PhotoImage(file="translab_photos/afficheur_04_4.png"))
affg.append(PhotoImage(file="translab_photos/afficheur_04_5.png"))
affg.append(PhotoImage(file="translab_photos/afficheur_04_6.png"))
affg.append(PhotoImage(file="translab_photos/afficheur_04_7.png"))
affg.append(PhotoImage(file="translab_photos/afficheur_04_8.png"))
affg.append(PhotoImage(file="translab_photos/afficheur_04_9.png"))
affg.append(PhotoImage(file="translab_photos/afficheur_04_eteint.png"))
affg.append(PhotoImage(file="translab_photos/afficheur_04_tiret.png"))
affd.append(PhotoImage(file="translab_photos/afficheur_03_0.png"))
affd.append(PhotoImage(file="translab_photos/afficheur_03_1.png"))
affd.append(PhotoImage(file="translab_photos/afficheur_03_2.png"))
affd.append(PhotoImage(file="translab_photos/afficheur_03_3.png"))
affd.append(PhotoImage(file="translab_photos/afficheur_03_4.png"))
affd.append(PhotoImage(file="translab_photos/afficheur_03_5.png"))
affd.append(PhotoImage(file="translab_photos/afficheur_03_6.png"))
affd.append(PhotoImage(file="translab_photos/afficheur_03_7.png"))
affd.append(PhotoImage(file="translab_photos/afficheur_03_8.png"))
affd.append(PhotoImage(file="translab_photos/afficheur_03_9.png"))
affd.append(PhotoImage(file="translab_photos/afficheur_03_eteint.png"))
affd.append(PhotoImage(file="translab_photos/afficheur_03_tiret.png"))
depla=80   #80
can1=Canvas(fen1,width=fen1x, height=fen1y, relief=SOLID, scrollregion=(-dimx,-dimy,dimx,dimy),xscrollincrement=depla,yscrollincrement=depla, bd=3)

can1.grid(row=0,column=0)
#depla_f=can1["xscrollincrement"]


for arrow in ["Left", "Right", "Down", "Up"]:
    fen1.bind('<%s>' %arrow, scroll)

dessine()

root.geometry("+1000+10")
fen1.bind("<Button-1>",but_1)

fen1.bind("<Shift-Button-1>",shift_but_1)
fen1.bind('<Button-3>',but_3)
fen1.bind('<Shift-Button-3>',shift_but_3)

type_action=IntVar()
type_action.set(2)
choix_tout=Radiobutton(root,text='Mise en place des composants',variable=type_action,value=0,command=choix_action)
choix_trace_fils=Radiobutton(root,text="Tracé des fils",variable=type_action,value=1,command=choix_action)
choix_vites=Radiobutton(root,text='Mise en fonctionnement',variable=type_action,value=2,command=choix_action)
choix_tout.grid(row=0,column=0)
choix_trace_fils.grid(row=0,column=1)
choix_vites.grid(row=0,column=2)

bou1=Button(root, text='L +',width=4,command=fen1xplus)
bou1.grid(row=5,column=4)
bou2=Button(root,text='L -',width=4,command=fen1xmoins)
bou2.grid(row=5,column=5)
bou4=Button(root, text='H +',width=4,command=fen1yplus)
bou4.grid(row=5,column=6)
bou5=Button(root,text='H -',width=4,command=fen1ymoins)
bou5.grid(row=5,column=7)


#bou3=Button(root,text='Calcul état des connexions',width=25,command=cal_con2)
#bou3.grid(row=1,column=0,columnspan=4)
#bou4=Button(fen2,text='Calcul état des sorties composants',width=50,command=calc_circ)
#bou4.grid(row=8,column=0,columnspan=4)
bou10=Button(root,text='Ouvrir trans_nn.txt',width=25,command=o_f)
bou10.grid(row=2,column=0,columnspan=4)
bou11=Button(root,text='Enregistrer trans_nn+1.txt',width=25,command=e_f)
bou11.grid(row=4,column=0,columnspan=4)

charge_0=1
icompolu=0
devices=["Transistor NPN","Pile","Commutateur","Condensateur 47 µF","quadruple NAND","quadruple OU","afficheur double"]
lbox1 = Listbox(
root,
width=40,
height=2,
selectbackground="blue")
lbox1.grid(row=1,column=3,columnspan=4,rowspan=2)

for item in devices:
    lbox1.insert(END, item)

sbar = ttk.Scrollbar(root, command=lbox1.yview)
sbar.grid(row=1,column=7,rowspan=2)

lbox1.config(yscrollcommand=sbar.set)
def show(event):
    global icompolu
    icompolu = lbox1.curselection()[0]

lbox1.bind('<<ListboxSelect>>', show)

entree3=Entry(root,width=10)
entree3.grid(row=3,column=6)
entree4=Entry(root,width=41,fg='red')
entree4.grid(row=0,column=5,columnspan=2)
ident='Identifiant définitif demandé'
entree4.insert(0,ident)
entree5=Entry(root,width=70,fg='green')
entree5.grid(row=3,column=0,columnspan=3)
commentaire='Commentaire facultatif'
entree5.insert(0,commentaire)
texte=Label(root)
texte.configure(text='Numéro de fichier nn : ')
texte.grid(row=3,column=4,columnspan=2)
texte2=Label(root)
texte2.configure(text='TRANSLAB Version 18.06')
texte2.grid(row=5,column=0,columnspan=2)

cond_conf=os.path.isfile('configtrans.txt')
if cond_conf:
    cf=open('configtrans.txt','r')
    nbfic=int(cf.readline())
    entree3.insert(0,str(nbfic))
    cf.close()
else:
    cf=open('configtrans.txt','w')
    nbfic=0
    entree3.insert(0,str(nbfic))
    cf.write('0\nNumero du dernier fichier trans créé')
    cf.close()
root.mainloop()





